/* Skript zur Demonstration von Analyitschen Funktionen
 * Als Benutzer SCOTT ausführen
 */
 
-- Verwendung der analytischen Variante der Gruppenfunktionen
select deptno, ename, sal,
       sum(sal) over (partition by deptno) dept_sal,
       sum(sal) over (
         partition by deptno
         order by deptno, sal, ename) cum_dept_sal,
       sum(sal) over (
         order by deptno, sal, ename) cum_tot_sal
  from emp
 order by deptno, sal, ename;
 
-- Variante mit abweichender ORDER BY Klausel
select deptno, ename, sal,
       sum(sal) over (partition by deptno) dept_sal,
       sum(sal) over (
         partition by deptno
         order by deptno, sal desc, ename) cum_dept_sal,
       sum(sal) over (
         order by sal, ename) cum_tot_sal
  from emp
 order by deptno, sal, ename;
 
-- Variante mit fehlender PARTITION BY und ORDER BY-Klausel
select ename, job, sal, 
       sum(sal) over () sum_sal,
       avg(sal) over () avg_sal,
       max(sal) over () max_sal
  from emp;
  
-- Analytische Funktionen mit Berichtsfunktionen auf mehreren Ebenen
select ename, job, sal,
       sum(sal) over (
         partition by deptno) sum_dept_sal,
       sum(sal) over () sum_tot_sal
  from emp
 order by deptno, ename;

-- Ein weiteres Beispiel für analytische Funktionen 
select ename, sal,
       avg(sal) over (
         partition by deptno, job) avg_job_sal,
       count(*) over (
         partition by deptno) dept_count,
       stddev(sal) over (
         partition by deptno
         order by deptno, sal, ename) dept_sal_dev
  from emp
 order by deptno, sal, ename;
  
-- Kombination von analytischen Funtkionen mit Gruppenfunktionen
select deptno, job, sum(sal) dept_sum_sal
  from emp
 group by deptno, job
 order by deptno, job;

-- Verwendung von analytischen Funktionen auf verschiedenen Gruppierungsebenen
select deptno, job, sum(sal) dept_sum_sal,
       sum(sum(sal)) over () sum_tot_sal,
       sum(sum(sal)) over (
         partition by deptno) sum_dept_sal,
       sum(sum(sal)) over (
         partition by job) sum_job_sal
  from emp
 group by deptno, job
 order by deptno, job;
 
-- Vergleich der Auswertung mit einer group by cube-Auswertung
select deptno, job, sum(sal) dept_sum_sal
  from emp
 group by cube (deptno, job)
 order by deptno, job;

-- komplexeres Beispiel einer analytischen Funktion mit Gruppenfunktionen
select p.prod_category, p.prod_subcategory, p.prod_id,
       sum(amount_sold) sales,
       sum(sum(amount_sold)) over (
         partition by p.prod_category) cat_sales,
       sum(sum(amount_sold)) over (
         partition by p.prod_subcategory) subcat_sales
  from sales s
  join customers c on s.cust_id = c.cust_id
  join countries co on c.country_id = co.country_id
  join products p on s.prod_id = p.prod_id
 where s.time_id = to_date('11.10.2000', 'dd.mm.yyyy')
 group by p.prod_category, p.prod_subcategory, p.prod_id
 order by prod_category, prod_subcategory;
 
-- Verwendung der Funktion RATIO_TO_REPORT
select deptno, ename, job, sal,
       round(ratio_to_report(sal) over 
         (partition by deptno) * 100, 1) dept_perc_sal,
       round(ratio_to_report(sal) over () * 100, 1) tot_perc_sal
  from emp;
 
-- Verwendung der WINDOWING-Klausel mit ROWS
select p.prod_id, trunc(s.time_id, 'MM') sales_month,
       sum(amount_sold) sales,
       avg(sum(amount_sold)) over (
         partition by trunc(s.time_id, 'MM')
         order by trunc(s.time_id, 'MM')
         rows between 2 preceding and current row) 
       three_month_avg
  from sales s
  join customers c on s.cust_id = c.cust_id
  join countries co on c.country_id = co.country_id
  join products p on s.prod_id = p.prod_id
 where p.prod_id = 13 
   and s.time_id >= to_date('01.01.2001', 'dd.mm.yyyy')
 group by p.prod_id, trunc(s.time_id, 'MM')
 order by sales_month;
 
-- Verwendung der WINDOWING-Klausel mit RANGE
select p.prod_id, trunc(s.time_id, 'MM') sales_month,
       sum(amount_sold) sales,
       avg(sum(amount_sold)) over (
         partition by trunc(s.time_id, 'MM')
         order by trunc(s.time_id, 'MM')
         rows between 2 preceding and current row) 
       three_month_avg
  from sales s
  join customers c on s.cust_id = c.cust_id
  join countries co on c.country_id = co.country_id
  join products p on s.prod_id = p.prod_id
 where p.prod_id = 13 
   and s.time_id >= to_date('01.01.2001', 'dd.mm.yyyy')
 group by p.prod_id, trunc(s.time_id, 'MM')
 order by sales_month;
 
select c.channel_desc, 
       to_char(s.time_id, 'yyyy/Q') month, 
       sum(s.quantity_sold) sum_quantity,
       count(*) over (order by sum(s.quantity_sold) 
                      range between 1000 preceding 
                                and 1000 following) anzahl
  from sales s
  join channels c on s.channel_id = c.channel_id
  join products p on s.prod_id = p.prod_id
 where s.time_id >= to_date('01.01.2000', 'dd.mm.yyyy')
   and c.channel_id = 3
group by c.channel_desc, to_char(s.time_id, 'yyyy/Q')
 order by sum(s.quantity_sold);
 
-- Verwendung der Funktionen RANK und DENSE_RANK
select ename, sal,
       rank () over (
         order by sal desc) top_sal,
       rank () over (
         order by sal) sal_rang,
       dense_rank() over (
         order by sal) sal_rang_dense
  from emp
 order by top_sal;
 
-- Verwendung der Funktionen FIRST und LAST
select ename, job, sal,
       min(sal) keep (dense_rank first order by sal)
       over (partition by deptno) low_dept_sal,
       max(sal) keep (dense_rank last order by sal)
       over (partition by deptno) high_dept_sal
  from emp
 order by deptno, sal desc;

select ename, job, sal,
       min(sal) over (
         partition by deptno) low_dept_sal,
       max(sal) over (
         partition by deptno) high_dept_sal
  from emp
 order by deptno, sal desc;

-- Verwendung der Funktionen FIRST_VALUE und LAST_VALUE
select ename, comm,
       last_value(comm) ignore nulls over (
         order by ename) last_values,
       first_value(comm) ignore nulls over (
         order by ename) first_values
  from emp
 order by ename;

-- Korrektur der Verwendung durch ein explizites Fenster
select ename, comm,
       last_value(comm) ignore nulls over (
         order by ename
         range between unbounded preceding and
               current row) last_values,
       first_value(comm) ignore nulls over (
         order by ename
         range between unbounded preceding and
               unbounded following) first_values
  from emp
 order by ename;

-- Verwendung der Funktion PERCENT_RANK
select ename, job, sal,
       round(percent_rank() over 
         (order by sal desc) * 100, 1) perc_rank
  from emp;
 
-- Verwendung der Funktion ROW_NUMBER
select ename, sal,
       row_number() over (
         partition by deptno
         order by sal desc, ename) dept_row_num,
       row_number() over (
         order by sal desc, ename) tot_row_num,
       rank() over (
         order by sal desc) tot_rank
  from emp
 order by sal desc, ename;
  
-- Verwendung der Funktionen LAG und LEAD
alter session set nls_date_format = 'dd.mm.yyyy';
select ename, hiredate, 
       hiredate - 
         lag(hiredate) over (order by hiredate) hired_after,
       lead(hiredate) over (order by hiredate)
           - hiredate hired_before
  from emp;
  
-- weiteres Beispiel für die Funktion LAG und LEAD
select ename, job, sal, 
       sal - lag(sal) over (
         partition by deptno
         order by sal, ename) more_than,
       lead(sal) over (
         partition by deptno
         order by sal, ename) - sal less_than
  from emp
 order by deptno, sal, ename;
 
-- Die Funktion LAG mit dynamisch berechnetem Offset
select deptno, ename,
       (select count(*)
             from emp 
            where deptno = e.deptno
              and hiredate > e.hiredate) offset,
       hiredate - 
       lag(hiredate, 
          (select count(*)
             from emp 
            where deptno = e.deptno
              and hiredate < e.hiredate))
         over (order by deptno, hiredate) hired_after
  from emp e
 order by deptno, hiredate;
 
-- Alternative (vereinfachte) Abfrage:
select deptno, ename, hiredate,
       hiredate - 
       (select min(hiredate)
          from emp 
         where deptno = e.deptno)  hired_after
  from emp e
 order by deptno, hiredate;

-- Behandlung von null-Werten in LAG bzw. LEAD
select deptno, ename, sal, mgr, 
       lead(mgr ignore nulls, 1, 0)
         over (partition by deptno
               order by sal) colleague_mgr
  from emp;
  
